//This file is part of FiveIMSNickCollinsPhD. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file FiveIMSNickCollinsPhD.help


Substituet {
	var synths;
	var w, view, group;
	var freezebutton, matchslid, paramslid,xy, swap;
	var debug;
	var bus1, bus2;
	var presetbutton, preset, lasttimepressed, timepressed, timeelapsed;
	
	*new {arg debug=false, buffer, threshold=0.01;
		^super.new.initSubstituet(debug,buffer,threshold).initPresets.initGUI.initState;
	}
	
	initSubstituet {arg dbg,b,threshold;
		
		lasttimepressed=Main.elapsedTime;
	
		group= Node.basicNew(Server.default,1);

		debug=dbg;
		
		synths=Array.fill(2);
				
		if (debug) {
		
		bus1= 20;
		bus2= 21;
		
		//buffer is stereo
		
		//Synth.head(group,\playbuftest,[\out,bus1,\bufnum,b[0].bufnum]);
		//Synth.head(group,\playbuftest,[\out,bus2,\bufnum,b[1].bufnum]);
		
			//so as to hear them
		//Synth.head(group,\playbuftest,[\out,0,\bufnum,b[0].bufnum]);
		//Synth.head(group,\playbuftest,[\out,1,\bufnum,b[1].bufnum]);
		
		//stereo
		Synth.head(group,\playbuftest2,[\out,bus1,\bufnum,b.bufnum]);
		Synth.head(group,\playbuftest2,[\out,0,\bufnum,b.bufnum]);
		
	
		//make synths
		synths[0]= Synth.tail(group,\substituet,[\out,0,\controlbus,bus1,\inputbus,bus2,\freezestore,1,\amp,0.0,\threshold,threshold]);
		synths[1]= Synth.tail(group,\substituet,[\out,0,\controlbus,bus2,\inputbus,bus1,\freezestore,1,\amp,0.0,\threshold,threshold]);
		} 
		{
		
		bus1= 8;
		bus2= 9;
		
		//make synths
		synths[0]=Synth.tail(group,\substituet,[\out,0, \controlbus,bus1,\inputbus,bus2,\freezestore,1,\amp,0.0,\threshold,threshold]);
		synths[1]=Synth.tail(group,\substituet,[\out,0,\controlbus,bus2,\inputbus,bus1,\freezestore,1,\amp,0.0,\threshold,threshold]);
		};
		
		Synth.tail(group, \OrnamatonLimiter,[\inbus,0, \outbus, 0]); 
		
	}
	
		
	initGUI {

		freezebutton=Array.fill(2,nil);
		matchslid=Array.fill(2,nil);
		paramslid=Array.fill(2*6,nil);
		xy=Array.fill(2,nil);
			
		//make GUI
		
		w=SCWindow("substituet",Rect(600,600,400,600));
		
		//txtbox controls for busses, tick for freeze, slid for matchlength and 4 weightings, 2d slider for seektime, seekdur 
		//preset recall buttons		
		
		SCStaticText(w,Rect(5,5,40,40)).string_("Dan");
		SCStaticText(w,Rect(205,5,40,40)).string_("Inga");	
			
		synths.do({arg synth,j;	
		var shift;
		
		shift=j*200;		
				
		freezebutton[j]= SCButton(w, Rect(105+shift,5,90, 40)); 
		freezebutton[j].states= [["unfrozen"],["frozen"]]; 
		freezebutton[j].action_({arg butt;
		//[\freeze,butt.value].postln;
		synth.set(\freezestore,butt.value);	
		});
		
		matchslid[j]=DDSlider(w,Rect(5+shift,105, 190, 30), "matchlength", 0.005, 1.0, \exponential, 0.005, 0.05);
		matchslid[j].action_({arg val; synth.set(\matchlength,val);});
		
		6.do({arg i;
		paramslid[(j*6)+i]=DDSlider(w,Rect(5+shift,140+(40*i)+5, 190, 30),["zcr wt","lms wt","sc wt","st wt","amp","track"][i], 0.0, 1.0, \linear,0.1,1.0);
		paramslid[(j*6)+i].action_({arg val; synth.set([\zcr,\lms,\sc,\st,\amp,\track][i],val);});
		});
		
		xy[j]=SC2DSlider(w,Rect(5+shift,400,190,90));
		xy[j].action_({arg slid;
				synth.set(\seektime,10*(slid.x),\seekdur,10*(slid.y));
				});
		
		});
		
		
		
		
		//presets- can't go back here, but I guess that's OK, safer?! (allow reset button)
		presetbutton= SCButton(w, Rect(205,500,90, 40)); presetbutton.states= [["state"]]++(Array.fill(26,{arg i; [(i+97).asAscii.asString]})); 
		
		presetbutton.action_({arg butt;
		var val,presetdata, mode;
		
		val=butt.value;
		
		timepressed=Main.elapsedTime;
		
		timeelapsed=timepressed-lasttimepressed;
		
		//half a second must have passed, avoid double hits
		if(timeelapsed>0.5, {
		
		//no normalisation required! This is why was not matching and silent...
		//timeelapsed= (timeelapsed/10.0).min(1.0); //normalise to ten seconds
		
		[\last, lasttimepressed, \time, timepressed, \elapsed, timeelapsed, \presetbuttval,val].postln;
		
		lasttimepressed=timepressed;
		
		presetdata=preset.wrapAt(val);
		
		mode=presetdata[0];
		
		if(mode==2,{
		//this.setboth(presetdata[1],presetdata[2],timeelapsed)
		this.setplayer(0,presetdata[1],timeelapsed);
		this.setplayer(1,presetdata[2],timeelapsed);
		},
		{this.setplayer(mode,presetdata[1],timeelapsed); 
		 this.otherplayer(1-mode);
		});
		
		},{
		//else reset mode  
		
		butt.value_(butt.value-1);
		});
		
		});
		
		
		//swap button- might remove! 
	//	
//		swap= SCButton(w, Rect(5,500,90, 40)); swap.states= [["dan"],["inga"]]; 
//		swap.action_({arg butt;
//		var vol;
//		
//		vol= butt.value;
//		
//		vol.postln;
//		
//		//when Dan playing back from Inga, Inga's concat is unfrozen (collecting from Dan) but Dan's concat is frozen (using previously collected from Inga)
//		synth[0].set(\freezestore,1-vol);	
//		synth[1].set(\freezestore,vol);	
//		
//		freezebutton[0].value_(1-vol);
//		freezebutton[1].value_(vol);
//		
//		synth[0].set(\amp,1.0-vol);	
//		synth[1].set(\amp,vol);
//		
//		paramslid[4].value_(1.0-vol);
//		paramslid[9].value_(vol);
//		
//		});
		//		
//				//defaults, startup
//		synth[0].set(\freezestore,1);	
//		synth[1].set(\freezestore,0);	
//		
//		freezebutton[0].value_(1);
//		freezebutton[1].value_(0);
//		
//		synth[0].set(\amp,0.0);	
//		synth[1].set(\amp,0.0);
//		
//		paramslid[4].value_(0.0);
//		paramslid[9].value_(0.0);
			
		
		w.front;
	}
	
	//preset state 0 in readiness
	initState {
		var presetdata; 
		//initialisation
		
		presetdata=preset[0];
		
		//this.setboth(presetdata[1],presetdata[2],timeelapsed)
		this.setplayer(0,presetdata[1],1.0);
		this.setplayer(1,presetdata[2],1.0);	
		
	
	}
	
	
	initPresets {
			
		//not sure if will ever set search area- can play with this on the GUI anyway...	
		//[danmatchlength, danzcr, danlms, dansc, danst, danamp, dantrack, danpast, dandur]
		//same for inga- have inital flag to say if 0= set dan on (sets inga off auto), 1 inverse, 2 set params for both
		
		
		//[mode,[data1],[data2]]	mode 0 = dan playing 1= inga playing 2= both playing
				
		//if in data past or dur= nil, set from timer info		
			
		//if dan playing so his store is frozen- ingas will be unfrozen	
				
		preset=[
		[2,[0.05, 1.0,0.0,1.0,1.0, 0.0,0.0, 5.0,5.0],[0.05, 0.0,1.0,0.0,0.0, 0.0,0.0, 5.0,5.0]], //initialise?
		
		[0,[0.05, 0.0,1.0,0.0,0.0, 0.0,0.0, 5.0,5.0]], //rehearsal mark A
		[1,[0.05, 0.0,1.0,0.0,0.0, 0.0,0.0, 5.0,5.0]], //rehearsal mark B
		
		//was 0.2
		
		[0,[0.2, 0.0,1.0,0.0,0.0, 1.0,0.0, 5.0,5.0]], //rehearsal mark C
		[1,[0.2, 0.0,1.0,0.0,0.0, 1.0,0.0, 5.0,5.0]], //rehearsal mark D
		[0,[0.14, 0.0,1.0,0.0,0.0, 1.0,0.0, 5.0,5.0]], //rehearsal mark E //was 0.15
		[1,[0.15, 0.0,1.0,0.0,0.0, 1.0,0.0, 5.0,5.0]], //rehearsal mark F
		
		//end was 
		
		[0,[0.05, 0.0,1.0,0.0,0.0, 1.0,1.0, 5.0,5.0]], //rehearsal mark G
		[1,[0.05, 0.0,1.0,0.0,0.0, 1.0,1.0, 5.0,5.0]], //rehearsal mark H
		
		[0,[0.1, 0.0,0.0,1.0,1.0, 1.0,1.0, 5.0,5.0]], //rehearsal mark I
		[1,[0.1, 0.0,0.0,1.0,1.0, 1.0,1.0, 5.0,5.0]], //rehearsal mark J //was 0.05 and wts 1 0 0 1
		
		
		[0,[0.005, 0.0,1.0,0.3,0.0, 1.0,1.0, 5.0,5.0]], //rehearsal mark K  smallest grains added amp tracking back in
		
		//L and M restored amp tracking
		[1,[0.005, 0.0,1.0,0.3,0.0, 1.0,1.0, 5.0,5.0]], //rehearsal mark L
		
        [2,[0.01, 1.0,0.0,0.3,0.0, 1.0,1.0, 5.0,5.0],[0.01, 0.0,1.0,0.0,0.3, 1.0,1.0, 5.0,5.0]], //rehearsal mark M
	
		//was too small at 0.005
	   [2,[0.05, 1.0,0.0,1.0,1.0, 1.0,0.0, 5.0,5.0],[0.05, 1.0,0.0,1.0,1.0, 1.0,1.0, 5.0,5.0]], //rehearsal mark N
       
       //swapped order
       
        [1,[0.2, 0.0,1.0,0.0,0.0, 1.0,0.0, 5.0,5.0]], //rehearsal mark O
		[0,[0.08, 0.2,1.0,0.4,0.3, 1.0,0.0, 5.0,5.0]], //rehearsal mark P was with amp track
 
        [1,[0.02, 0.1,1.0,0.5,0.2, 1.0,1.0, 5.0,5.0]], //rehearsal mark Q
		[0,[0.2, 0.0,1.0,0.0,0.0, 1.0,0.0, 5.0,5.0]], //rehearsal mark R

//were 0.5
        [1,[0.25, 0.0,1.0,0.0,0.0, 1.0,0.0, 5.0,5.0]], //rehearsal mark S
		[0,[0.25, 0.0,1.0,0.0,0.0, 1.0,0.0, 5.0,5.0]], //rehearsal mark T

		[1,[0.005, 0.0,1.0,0.3,0.0, 1.0,0.0, 5.0,5.0]], //rehearsal mark U
		
		//was 0.3
        [2,[0.12, 1.0,0.0,0.3,0.0, 1.0,0.0, 5.0,5.0],[0.3, 0.0,1.0,0.0,0.3, 1.0,0.0, 5.0,5.0]], //rehearsal mark V

		//was 0.005 and features 1 0 0 1
		[2,[0.01, 0.1,1.0,0.0,0.2, 1.0,0.0, 5.0,5.0],[0.01, 0.0,1.0,0.1,0.2, 1.0,0.0, 5.0,5.0]], //rehearsal mark W

		//0.27, 0.28
        [2,[0.17, 0.0,1.0,0.0,0.3, 1.0,0.0, 5.0,5.0],[0.18, 1.0,0.0,0.3,0.0, 1.0,0.0, 5.0,5.0]], //rehearsal mark X

		[2,[0.1, 0.0,1.0,0.0,0.0, 1.0,1.0, 5.0,5.0],[0.1, 0.0,1.0,0.0,0.0, 1.0,1.0, 5.0,5.0]], //rehearsal mark Y

		[2,[0.05, 1.0,0.0,1.0,1.0, 0.0,0.0, 5.0,5.0],[0.05, 0.0,1.0,0.0,0.0, 0.0,0.0, 5.0,5.0]], //rehearsal mark Z  piece end, silent
				
	   ];

	}


	
	//currently playing is which, so must freeze collect for this one
	setplayer {  arg which, data,timeelapsed;
	
					//defaults, startup
		synths[which].set(\freezestore,1, \matchlength,data[0]);	//always freeze for this mode
		freezebutton[which].value_(1);
		matchslid[which].value_(data[0]);
		
		
		synths[which].setn(\zcr,data[1..6]); //successively maps 6 params
		
		6.do({arg i;
		
		//synth[which].set([\zcr,\lms,\sc,\st,\amp,\track][i],0.0);	
		paramslid[(which*6)+i].value_(data[i+1]);
		});
		
		synths[which].set(\seektime,timeelapsed,\seekdur,timeelapsed);
		
		xy[which].x_(timeelapsed);
		xy[which].y_(timeelapsed);
		
	}
	

	//set to collecting, zero amp, other params unimportant	
	otherplayer {arg which;
		
		synths[which].set(\freezestore,0, \amp, 0.0);
		freezebutton[which].value_(0);
		
		//amp level 0.0 to avoid hearing it
		paramslid[(which*6)+4].value_(0.0);
		
	}
	
	//setboth { arg data1,data2, timeelapsed;
//	
//	
//	}
	
	
	
	
	*initClass {
			
		StartUp.add({	
			
		//added an Amplitude tracker as optional volume control 
		
		//seem to have a randscore input where amp is- also, amplitude control of Concat gives its output level
		SynthDef.writeOnce(\substituet,{arg out=0, controlbus=0, inputbus=8, seektime=1.0, seekdur=1.0, matchlength=0.05, freezestore=0, zcr=1.0, lms=1.0, sc=1.0, st=0.0, amp=0.0, track=0.0, randscore=0.0,threshold=0.01, pan=0.0;
		var concat, control, input, amptrack, output, interp;
		
		control= In.ar(controlbus,1);
		
		input= In.ar(inputbus,1);
		
		amptrack=(10*Amplitude.ar(control)).clip2(1); //too quiet otherwise, limiter will deal
		
		//add noise to matchlength LFNoise0.kr(100,0.025,0.025+matchlength) works for small grains otherwise less good
		concat= Concat2.ar(control,input,10.0,seektime,seekdur,LFNoise0.kr(100,0.2*matchlength,(1+0.2)*matchlength),freezestore,zcr, lms, sc, st,randscore,threshold, amp);
		
		output= concat*((1.0-track)+ (track*amptrack));
		
		Out.ar(out,Pan2.ar(output,pan))
		}); //.load(s);
		
		
		SynthDef.writeOnce(\playbuftest,{arg out=0, bufnum;
		var playbuf;
		
		playbuf=PlayBuf.ar(1,bufnum,BufRateScale.kr(bufnum),loop: 1.0);
		
		Out.ar(out,playbuf);
		}); //load(s);
			
			
		SynthDef.writeOnce(\playbuftest2,{arg out=0, bufnum;
		var playbuf;
		
		playbuf=PlayBuf.ar(2,bufnum,BufRateScale.kr(bufnum),loop: 1.0);
		
		Out.ar(out,playbuf);
		
		}); //load(s);	
		
				
		SynthDef.writeOnce(\playbuftest2debug,{arg out=0, bufnum;
		var playbuf;
		
		playbuf=PlayBuf.ar(2,bufnum,BufRateScale.kr(bufnum),loop: 0.0);
		
		Out.ar(out,playbuf*EnvGen.ar(Env([1,1],[120]),doneAction:2));
		
		
		//Out.ar(0,DelayN.ar(playbuf,1,1));
		}); //load(s);	
			
		});
			
		//SynthDef.writeOnce(\OrnamatonLimiter,{arg inbus=0, outbus=0;  
//				ReplaceOut.ar(outbus, Limiter.ar(In.ar(inbus,2),0.999,0.005));
//			});	
//			
			
	}

} 